{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:40:44 $                                        =}
{========================================================================}
unit Unit1;

{
 There are three things user should do to get screensaver work:

 1) Put TMMScreenSaver component onto the form.
 2) Override CreateParams procedure to make it the same as in this demo
 3) Rename .EXE to .SCR and put to system directory

 Please check Dialog 'Parameters': /s was set to start the saver

 Important: To use this saver within Windows all parameter settings
 should be removed!!!!

 Note:
 If you want to test your Setup-Dialog, you have to set as Parameter '/c'.
 Windows will try to start your screensaver with this parameter to request
 an existing Setup-Dialog ('/s' for starting the screensaver). You have
 to set this parameter in the Parameters-Option in Delphi's Start-Menu.
 If there is no use of a setup-dialog, forget this note.
 Please take also a look at the project file!

 To implement this demo-saver into your windows environment, rename the
 exe-File to a scr-File and copy it to your windows directory.

 Parameters overview:

 /c : kConfigDialog;
 /s : FullScreen;
 /w : NormalWindow;
 /p : ChildPreview;
 /a : SetPassword;

}

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  ExtCtrls,
  MMObj,
  MMScrsv;

type
  TSaverForm = class(TForm)
    ScreenSaver: TMMScreenSaver;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure ScreenSaverSetupDlg(Sender: TObject);
    procedure ScreenSaverPasswordResume(Sender: TObject);
    procedure ScreenSaverPasswordSuspend(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  end;

var
  SaverForm: TSaverForm;

implementation

uses Unit2;

{$R *.DFM}

{$R SAVER.RES}

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.CreateParams(var Params: TCreateParams);
begin
   inherited CreateParams(Params);

   ScreenSaver.CreateParams(Params);
end;

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.FormCreate(Sender: TObject);
begin
   (*with ScreenSaver do
   NoteBook.PageIndex := IniFile.ReadInteger('SCRSAVE:MYSAVER','Mode', 0);*)
end;

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.FormShow(Sender: TObject);
begin
   if ScreenSaver.PreviewMode then
   begin
      // maybe you need special setup when in preview mode ?
   end
   else
   begin

   end;

   Randomize;
   Timer1.Enabled := True;
end;

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer1.Enabled := False;
end;

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.ScreenSaverSetupDlg(Sender: TObject);
var
   Setup: TSetupForm;
begin
   Setup := TSetupForm.Create(Application);
   Setup.ShowModal;
   Setup.Free;
end;

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.ScreenSaverPasswordSuspend(Sender: TObject);
begin
   // Password Dialog called
   Timer1.Enabled := False;
end;

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.ScreenSaverPasswordResume(Sender: TObject);
begin
   // Password Dialog closed
   Timer1.Enabled := True;
end;

{-- TSaverForm ----------------------------------------------------------------}
procedure TSaverForm.Timer1Timer(Sender: TObject);
begin
   with Canvas do
   begin
      Pen.Color := Random(MaxLongint);
      MoveTo(Random(Width),Random(Height));
      LineTo(Random(Width),Random(Height));
   end;
end;

end.
